<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/

include_once('../include/global.php');
$path = is_ftlogs_mounted(TRUE);
$filename = "ss-config.txt";

// We want toolname and toolversion early so we can use them in the page_h1 and page_breadcrumb. Read
// them in from the ss-config file. It's more convenient to ingest ss-config.txt further down on this 
// page so we can print any error messages w/in the context of the page, but we'll still try to snag 
// these 2 values here...
if (file_exists($path."/".$filename)){ 
	// try to read config file
	$testconfiglines = file($path."/".$filename);
	if ($testconfiglines !== false){ // read of config file was successful!
		// initialize...
		$toolname = "";
		$toolversion = "";
		$se_other_name = "";
		// get toolname and toolversion from ss-config.txt file
		foreach ($testconfiglines as $line){
			if(strpos($line, "toolname") !== false){
				$line_exploded = explode(" ", trim($line));
				$toolname = implode(" ", array_slice($line_exploded, 1));
			} else if(strpos($line, "toolversion") !== false){
				$line_exploded = explode(" ", trim($line));
				$toolversion = implode(" ", array_slice($line_exploded, 1));
			} else if (strpos($line, "se_other_name") !== false){
					$line_exploded = explode(" ", trim($line));
					$se_other_name = implode(" ", array_slice($line_exploded, 1));
			}						
		}
	} 
}

// ...any other form variables from selectsearchengine.php.
$case_id = $_POST['case_to_run'];

$page_title = "SS - Run Test Case";

// if we have a value for $toolname and $toolversion, use them in the page_breadcrumb
if ($toolname != ""){
	$page_breadcrumb = "Running String Search Tests for ".$toolname." Version ".$toolversion;
} else {
	$page_breadcrumb = "Running String Search Tests";
}

//$page_h1 = "Running a Test Case and Recording the Test Results";
$page_h1 = "Running Test Case ".$case_id." and Recording the Results";
// $root = '/tmp/';
include "ft_ss_need_logs.php";
include_once('../include/ss-global.php');

$continue = 1; // set $continue to true

// we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php (via ft_ss_need_logs.php).
if ($ftlogs_mounted != 1) { //  If the drive's not mounted, don't continue.
	$continue = 0;
}

// Try to pull back the values for selected_dataset and selected_engine that we have 
// stored in ss-last.txt 
if ($continue){
	$lastfile = "ss-last.txt";
	// initialize...
	$selected_dataset = "";
	$selected_engine = "";

	if (file_exists($path."/".$lastfile)){ // can we find ss-last.txt?
		// try to read the last selected dataset and search engine values
		$lastlines = file($path."/".$lastfile);
		if ($lastlines !== false){ // read of config file was successful!
			// get last used dataset and engine from ss-last.txt file
			foreach ($lastlines as $line){
				if(strpos($line, "selected_dataset") !== false){ 
					$line_exploded = explode(" ", trim($line));
					$selected_dataset = implode(" ", array_slice($line_exploded, 1));
				} else if(strpos($line, "selected_engine") !== false){ 
					$line_exploded = explode(" ", trim($line));
					$selected_engine = implode(" ", array_slice($line_exploded, 1));
				}	
			}
		} else { // read of ss-last.txt failed for some reason
			echo "<p><b>Error:</b> error opening ".$path."/".$lastfile.".</p>";				
			$continue = 0;
		}
	} else { // if ss-last.txt doesn't exist by now, something went wrong
		echo "<p><b>Error:</b> something went wrong. Couldn't find ".$path."/".$lastfile.".</p>";				
		$continue = 0;		
	}
}

if($continue){ // we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php  
	// (via ft_ss_need_logs.php). If the drive's not mounted, suppress/do not print the rest of this page.
	$dribble_file = fopen ("/tmp/dribble-res.txt","w");
	fprintf ($dribble_file,"Start\n");
	fprintf ($dribble_file,"Parms -- Engine: %s Data Set %s\n",$selected_engine,$selected_dataset);

	/* $root is LOG home */
	$path = is_ftlogs_mounted(FALSE);
	
	fprintf ($dribble_file,"root: %s\n",$path);

/*	echo '<h1 style="font-size:1.8em;">'.$case_id.': ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</h1>';*/

/*	echo '<h3 style="font-size:1.6em; color:#9D0F19"> Test Case '.$case_id.' Description: ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</h3>';

//	echo '<p>Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i> for ';
//	echo 'Search Engine: <i><b>';
	echo '<h3 style="font-size:1.6em; color:#9D0F19">Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i>, ';
	echo 'Search Engine: <i><b>';
	if ($selected_engin/e == "Other"){
		echo $selected_engine." - ".$se_other_name;		
	} else {
		echo $selected_engine;		
	}
	echo '</b></i></h3>';*/
	
/*	echo '<h2 style="font-size:1.7em; color:#008000"> Test Case '.$case_id.' Description: ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</h2>';

//	echo '<p>Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i> for ';
//	echo 'Search Engine: <i><b>';
	echo '<h2 style="font-size:1.7em; color:#008000">Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i>, ';
	echo 'Search Engine: <i><b>';
	if ($selected_engin/e == "Other"){
		echo $selected_engine." - ".$se_other_name;		
	} else {
		echo $selected_engine;		
	}
	echo '</b></i></h2>';*/

/*	echo '<p>Test Case '.$case_id.' Description: <i>';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</i></p><p>';*/
	
	echo '<p>Test Case '.$case_id.' Description: <i>'.$full_case_desc[$case_id].'</i></p><p>';
	
//	echo '<p>Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i> for ';
//	echo 'Search Engine: <i><b>';
	echo 'Testing with Data Set:  <i><b>'.$selected_dataset.'</b></i>, ';
	echo 'Search Engine: <i><b>';
	if ($selected_engin/e == "Other"){
		echo $selected_engine." - ".$se_other_name;		
	} else {
		echo $selected_engine;		
	}
	echo '</b></i></p>';
	
/*	echo '<h2 style="font-size:1.7em; color:#008000"> <b>Test Case '.$case_id.': ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</b></h2>';

	echo '<h3 style="font-size:1.6em; color:#9D0F19"> <b>Test Case '.$case_id.' Description: ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</b></h3>';
	
	echo '<h1 style="font-size:1.8em;"> Test Case '.$case_id.': ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</h1>';
	

	
	echo '<p>Running Test Case '.$case_id.': ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</p>';

	echo '<h2 style="font-size:1.7em; color:#008000"> <b>Test Case '.$case_id.': ';
	// (I don't have a better way of doing this right now...)
	if (array_key_exists($case_id, $basic_dict)){ // the test case description will be in any one of 6 arrays
		echo $basic_dict[$case_id];					
	} elseif (array_key_exists($case_id, $logical_dict)){
		echo $logical_dict[$case_id];
	} elseif (array_key_exists($case_id, $unicode_dict)){
		echo $unicode_dict[$case_id];
	} elseif (array_key_exists($case_id, $tool_defined_dict)){
		echo $tool_defined_dict[$case_id];
	} elseif (array_key_exists($case_id, $special_dict)){
		echo $special_dict[$case_id];
	} elseif (array_key_exists($case_id, $regex_dict)){
		echo $regex_dict[$case_id];
	}
	echo '</b></h2>';*/


	
	/*printf ("<p>Testing Search Engine ");
	if ($selected_engine == "Other"){
		echo $selected_engine." - ".$se_other_name;		
	} else {
		echo $selected_engine;		
	}

	printf (" for case $case_id");*/

	if (strcmp($selected_dataset,'UNIX') == 0){
		$ds_explainer = file('unix-ex.txt');
		//echo ' using UNIX Data Set';
	} else {
		$ds_explainer = file('win-ex.txt');
		//echo ' using Windows Data Set';
	}

	$case_log_index ['goof'] = 'crud';
	$saved_comments = "";
	/*
	printf ("</p>");
	printf ("<p> Case Log File: ");
	$case_log_path = $root . '/' . $engine . '/' . $ds[0] . '/' . $case_id . '.txt';
	if (strcmp($ds[0],'UNIX') == 0){
	*/
	$case_log_path = $path . '/' . $selected_engine . '/' . $selected_dataset . '/' . $case_id . '.txt';
	fprintf ($dribble_file,"Log Path: %s\n",$case_log_path);
	/*
	printf ($case_log_path);
	*/
	if (file_exists($case_log_path)){
		$case_log_file = fopen ($case_log_path,"r");
		$no_log = 0;
		$in_comment = False;
		while (!feof($case_log_file)){
			$line = fgets($case_log_file);
			fprintf ($dribble_file,"LOG: %s",$line);
			/*
			printf ('<br>');
			printf ($line);
			*/
			$lx_split = explode(':',$line);
			if ($in_comment){
				$saved_comments = $saved_comments . $line;
			} else {
				if (strcmp($lx_split[0],"comments") == 0){
					$in_comment = True;
				}
				if (strcmp($lx_split[0],"active_hit") == 0 ||
					strcmp($lx_split[0],"unalloc_hit") == 0 ||
					strcmp($lx_split[0],"deleted_hit") == 0 
				){
					/*
					printf ("*** HIT *** %s",substr($lx_split[1],0,4));
					*/
					$case_log_index[substr($lx_split[1],0,4)] = "checked";
				}
				if (strcmp($lx_split[0],"meta_hit") == 0){
					$mix = $lx_split[1].':'.$lx_split[2];
					$case_log_index[$mix] = "checked";
				}
			}
		}
		/*
		print_r($case_log_index);
		*/
	} else {
		fprintf ($dribble_file,"No log file\n");
		$no_log = 1;
	}
	printf ("</p>");

	echo '<p><img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:0px 0;">';
	echo 'Follow the instructions on this page to configure your tool to run test case '.$case_id;
	echo ' and to document the results of the test, i.e., whether the string(s) searched for were found, ';
	echo 'notable behaviors, etc.</p>';

	
	echo "<p>1. Enter your name and an identifier (e.g., name) for the computer that's running the string search tool.</p>";
//	echo '<h2 style="font-size:1.7em; color:#008000"> <b>Admin Info</b></h2>';
	echo '<h2 style="font-size:1.6em; color:#008000"> <b>Admin Info</b></h2>';
	echo '<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x; margin-top: -0.2em; margin-bottom: .6em;">';	
	
	$look_for_end = 0;
	$is_active = 0;
	$is_deleted = 0;
	$is_unallocated = 0;
	$is_meta = 0;
	$is_string = 0;
	$is_setting = 0;
	printf ('<form method="POST"');
	printf ('action="../stringsearch/ft_ss_save_results.php">');
	$who = '';
	if (file_exists($path .'/'. 'ss_ur.txt')){
		$who = file($path .'/'. 'ss_ur.txt');
	}
	$get_who_old = <<<END
	<p>
	Enter the name (or initials) of the person running the test: &nbsp;
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	<input name="who" type="text" required value="%s"><br><br>
	Enter an identifier (e.g., name) for the computer running the test, i.e., the computer with the string search tool installed: &nbsp; 
	<input name="host" type="text" required value="%s"><br>
	</p>
	</div>
END;
	$get_who_new = <<<END
	<p>
	Enter the name (or initials) of the person running the test: &nbsp;
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	<input name="who" type="text" required value="%s"><br><br>
	Enter an identifier (e.g., name) for the computer that's running the String Search tool: &nbsp; 
	<input name="host" type="text" required value="%s"><br>
	</p>
	</div>
END;
	$get_who_newer = <<<END
	<table><tr><td style="width:5%;padding:0px;">
	Enter the name (or initials) of the person running the test:<br><br></td><td style="width:5%;padding:0px;">
	<input name="who" type="text" required size="30" value="%s"><br><br></td></tr><tr><td style="width:5%;padding:0px;">
	Enter an identifier (e.g., name) for the computer that's running<br>the string search tool:</td><td style="width:5%;padding:0px;">
	<input name="host" type="text" required size="30" value="%s"><br><br></td></tr></table>
	</div>
END;
	$get_who = <<<END
	<table><tr><td style="padding:0px;">
	Enter the name (or initials) of the person running the test:<br><br></td><td style="padding:0px;">
	<input name="who" type="text" required size="30" value="%s"><br><br></td></tr><tr><td style="padding:0px;">
	Enter an identifier (e.g., name) for the computer that's running<br>the string search tool:</td><td style="padding:0px;">
	<input name="host" type="text" required size="30" value="%s"><br><br></td></tr></table>
	</div>
END;
	
	
$whom = $who[0];
$host = $who[1];
printf ($get_who,$whom,$host);
	
	echo '<p>2. Make the <b><i>'.$selected_dataset.'</i></b> data set (test image), e.g., ss-';
	if ($selected_dataset == "Windows"){
		echo 'win';
	} else {
		echo 'unix';
	}
	echo '-07-25-18.dd, ';
	echo 'readable by your String Search tool, i.e., add it as evidence. You should have downloaded this from the CFReDS web site at an earlier step (see <a href="">here</a>).<br>';
	echo '3. Configure your tool to use the <b><i>'.$selected_engine.'</i></b> search engine.<br>';
//	echo '4. Adjust search tool parameters to those in the table below.</p>';
//	echo "4. Adjust your search tool's parameters to those in the table below.<br>";
	echo "4. Adjust your tool's search parameters to those in the table below.<br>";
	
	echo '<div style="font-size: 1.15em; padding-left: 0em; margin-top: -1em; line-height: 1.55em;"><img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;">';
	echo "What a setting is called varies from tool to tool and may not even be supported by your tool. Just make a reasonable choice and document the choice in the 'Comments and Observations' section below.<br>";
	echo '<img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;">';
	echo "The parameter settings, e.g., Case = Match Case, Whole Words = False, etc., are varied across the test cases to achieve tests with the most permutations.<br>";
	echo '<img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;">';
	echo "If a parameter isn't mentioned in the table, any setting should do, but try to make a reasonable choice.<br>";
/*	echo '<img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;">';
	echo '"Unicode=True" means turn on searching for UTF-8, UTF-16-BE and UTF-16-LE.<br>';*/
	echo '<img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;">';
	echo 'Your tool may require you to select a "language"; it should be OK to search for all the languages used in the data set at the same time, but if you are missing some strings, try one language at a time. The languages used in the data sets are: Arabic, Chinese (traditional & simplified), English, French, German, Italian, Japanese (Kanji, hiragana & katakana), Korean, Russian and Spanish.';
	echo '</div></p>';
	
//	echo '<h2 style="font-size:1.7em; color:#008000"> <b>Search Tool Settings</b></h2>';
	echo '<h2 style="font-size:1.6em; color:#008000"> <b>Search Tool Settings</b></h2>';
	echo '<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x; margin-top: -0.2em; margin-bottom: -.5em;">';		
	
	foreach ($ds_explainer as $explainer_line){
		$z = explode (' ',trim($explainer_line));
		fprintf ($dribble_file,"Line in file ==> %s\n",$explainer_line);
		if (strpos($explainer_line,'Case:') === false){
			if ($look_for_end == 1){
				if (strlen($explainer_line) <= 1){
					continue;
				}
				if (strcmp ($z[0],'Strings') == 0){
					$is_active = 0;
					$is_deleted = 0;
					$is_unallocated = 0;
					$is_meta = 0;
					$is_setting = 0;
					$is_string = 1;
				} elseif (strcmp ($z[0],'Active') == 0){
						fprintf ($dribble_file,"Start Active -- %s\n",$explainer_line);
					$is_deleted = 0;
					$is_unallocated = 0;
					$is_meta = 0;
					$is_string = 0;
					$is_setting = 0;
					$is_active = 1;
				} elseif (strcmp ($z[0],'Deleted') == 0){
					$is_active = 0;
					$is_unallocated = 0;
					$is_meta = 0;
					$is_string = 0;
					$is_setting = 0;
					$is_deleted = 1;
				} elseif (strcmp ($z[0],'Unallocated') == 0){
						fprintf ($dribble_file,"Start Unallocated -- %s\n",$explainer_line);
					$is_active = 0;
					$is_deleted = 0;
					$is_meta = 0;
					$is_string = 0;
					$is_setting = 0;
					$is_unallocated = 1;
				} elseif (strcmp ($z[0],'Meta-Data') == 0){
					$is_active = 0;
					$is_deleted = 0;
					$is_unallocated = 0;
					$is_string = 0;
					$is_setting = 0;
					$is_meta = 1;
				} elseif (strcmp ($z[0],'Settings') == 0){
					$is_active = 0;
					$is_deleted = 0;
					$is_unallocated = 0;
					$is_meta = 0;
					$is_string = 0;
					$is_setting = 1;
				} else {
					if ($is_active == 1){
						$a_list [] = $explainer_line;
						fprintf ($dribble_file,"Active -- %s\n",$explainer_line);
					}
					if ($is_setting == 1){
						$set_list [] = $explainer_line;
					}
					if ($is_string == 1){
						$str_list [] = $explainer_line;
					}
					if ($is_deleted == 1){
						$d_list [] = $explainer_line;
					}
					if ($is_unallocated == 1){
						$u_list [] = $explainer_line;
						fprintf ($dribble_file,"Unallocated -- %s\n",$explainer_line);
					}
					if ($is_meta == 1){
						$m_list [] = $explainer_line;
						fprintf ($dribble_file,"META -- %s\n",$explainer_line);
					}
				}
			}
		} else {
			if ($look_for_end == 1){
				$look_for_end = 0;
				$look_for_end = 0;
				$is_active = 0;
				$is_deleted = 0;
				$is_unallocated = 0;
				$is_meta = 0;
				$is_string = 0;
				$is_setting = 0;
				if (isset($set_list)){
					echo "";
					printf ("<table class=\"bordered_table\">\n");
					printf ("<tr><td style=\"border: 2px solid black;\">");
					printf ("Adjust search tool parameters to the following:");
					printf ("<tr><td>");
					$br = '';
					foreach ($set_list as $ww){
						printf ("$br");
						$br = '<br>';
						echo $ww;
					}
					printf ("</td></tr>");
					printf ("</table></div><br>\n");
				}

				if (isset($str_list)){
					echo "<p>5. Ask the search tool to look for each of the following strings and run the tool.<br>";
					echo '<img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;">';
					echo 'NOTE: the strings can also be found in the <i>string-search-test-cases.html</i> file that is included in the dataset download. The file should be opened in a browser on the test computer and  used to copy/paste the strings into the string search tool. This is particularly helpful for entering non-English search target strings.</p>';
					//	echo '<h2 style="font-size:1.7em; color:#008000"> <b>Search Strings</b></h2>';
					echo '<h2 style="font-size:1.6em; color:#008000"> <b>Search Strings</b></h2>';
					echo '<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x; margin-top: -0.2em; margin-bottom: -.5em;">';	
				
	//				echo "Search Strings:\n";
					printf ("<table class=\"bordered_table\">\n");
	//				printf ("<tr><td style=\"border: 2px solid black;\">");
					printf ("");
					printf ("<tr><td>");
					$br = '';
					foreach ($str_list as $ww){
						printf ("$br");
						$br = '<br>';
						echo $ww;
					}
					printf ("</td></tr>");
					printf ("</table></div>\n");
				}

				echo "<br><p>6. Record the results of the search below and click the 'Save Results' button to continue.</p>";
			//	echo '<h2 style="font-size:1.7em; color:#008000"> <b>Recording the Results</b></h2>';
				echo '<h2 style="font-size:1.6em; color:#008000"> <b>Recording the Results</b></h2>';

				echo '<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x; margin-top: -0.2em;">';	
?>

<!--<p>For a string located in an Active File or a Deleted File, the search tool should report the
containing file name and the text string found along with some context around
the reported string. Immediatly after the target string the string ID will be
included in the surrounding context. This should be enough information to select
the correct entry in the form below.</p><p> NOTE: I think there should be words on this page that state clearly the overall criteria for judging a hit and also letting the user know that the hit may show up in either of the tables below. 
</p><p> NOTE: Record false hits and other notable behaviors in the Comments and Observations section below.-->

<p>The table(s) below list each hit that the tool should have produced. Each instance of a given string in the data set has a unique string ID, e.g., 0848, associated with it. Examine the tool's search results and, making use of the string IDs and file names listed with the hits, check the boxes for each hit made by the tool. Record false hits and other notable behaviors in the Comments and Observations section below.
	
	
<?php
						
			if ((count($a_list) == count($d_list)) and (count($a_list) > 0)) {
				$n = count($a_list);
				printf ("<table class=\"bordered_table\">\n");
				printf ("<tr>");
				printf ("<th colspan=2 style=\"border: 2px solid black;\">Active Files</th>");
				printf ("<th colspan=2 style=\"border: 2px solid black;\">Deleted Files</th>");
				printf ("</tr>\n");
				for ($i = 0; $i < $n; $i++){
					printf ("<tr>");
					printf ("<td style=\"border: 2px solid black;\">");
					$str_id = substr($a_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					} else if ($no_log == 1){
							//$is_checked = 'checked="checked"';
							$is_checked = '';
					}
					
					printf ('<input type="checkbox" 
						%s name="ActiveFiles[]" value="%s">',
						$is_checked,$a_list[$i]);
					printf ("</td>\n");
					printf ("<td style=\"border: 2px solid black;\">");
					echo $a_list[$i];
					printf ("</td>");
					printf ("<td style=\"border: 2px solid black;\">");
					$str_id = substr($d_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					} else if ($no_log == 1){
							//$is_checked = 'checked="checked"';
							$is_checked = '';
					}
					
					printf ('<input type="checkbox" %s name="DeletedFiles[]" value="%s">', $is_checked,$d_list[$i]);
					printf ("</td>\n");
					printf ("<td style=\"border: 2px solid black;\">");
					echo $d_list[$i];
					printf ("</td>");
					printf ("</tr>\n");
				}
				printf ("</table>\n");
			} else {
				$n = count($a_list);
				/*
				for ($i = 0; $i < $n; $i++){
					echo $i .' ==> '.$a_list[$i];
					echo "\n";
				}
				*/
				$n = count($d_list);
				/*
				for ($i = 0; $i < $n; $i++){
					echo $i .' ==> '.$d_list[$i];
					echo "\n";
				}
				*/
				$n = count($a_list);
				if ($n > 0){
				printf ("<table class=\"bordered_table\">\n");
					printf ("<tr>");
					printf ("<th colspan=2 style=\"border: 2px solid black;\">Active Files</th>");
					printf ("</tr>\n");
				for ($i = 0; $i < $n; $i++){
					printf ("<tr>");
					printf ("<td style=\"border: 2px solid black;\">");
					$str_id = substr($a_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					} elseif ($no_log == 1){
						//$is_checked = 'checked="checked"';
						$is_checked = '';
					}
					printf ('<input type="checkbox" 
						%s name="ActiveFiles[]" value="%s">',
						$is_checked,$a_list[$i]);
						/*
					printf ('<input type="checkbox" name="ActiveFiles[]" value="%s">',
						$a_list[$i]);
						*/
					printf ("</td>\n");
					printf ("<td style=\"border: 2px solid black;\">");
					echo $a_list[$i];
					printf ("</td>");
					printf ("</tr>\n");
				}
				printf ("</table>\n");
				}
				$n = count($d_list);
				if ($n > 0){
				printf ("<table class=\"bordered_table\">\n");
					printf ("<tr>");
					printf ("<th colspan=2 style=\"border: 2px solid black;\">Deleted Files</th>");
					printf ("</tr>\n");
				for ($i = 0; $i < $n; $i++){
					printf ("<tr>");
					printf ("<td style=\"border: 2px solid black;\">");
					$str_id = substr($d_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					}
					elseif ($no_log == 1){
							//$is_checked = 'checked="checked"';
							$is_checked = '';
					}
					printf ('<input type="checkbox" 
						%s name="DeletedFiles[]" value="%s">',
						$is_checked,$d_list[$i]);
					/*
					printf ('<input type="checkbox" name="DeletedFiles[]" value="%s">',
						$d_list[$i]);
						*/
					printf ("</td>\n");
					printf ("<td style=\"border: 2px solid black;\">");
					echo $d_list[$i];
					printf ("</td>");
					printf ("</tr>\n");
				}
				printf ("</table>\n");
				}
			}
			$n = count($u_list);
fprintf ($dribble_file,"Unallocated List size: %d\n",$n);
			if ($n > 0){
?>

<!--<p><br>For a string located in Unallocated Space the search tool should provide some location
information and some context surronding the reported string. The Unallocated Space 
form lists for each string instance, the string ID, byte offset within the dd image, sector 
offset within the dd image, the target string and the string encoding (ASCII or UTF).-->
	
<p><br>
<img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;">
The Unallocated Space 
table lists for each string instance, the string ID, byte offset within the dd image, sector 
offset within the dd image, the target string and the string encoding (ASCII or UTF)
<?php
				printf ("<br><table class=\"bordered_table\">\n");
				printf ("<tr>");
				printf ("<th colspan=2 style=\"border: 2px solid black;\">Unallocated Space</th>");
				printf ("</tr>\n");
				for ($i = 0; $i < $n; $i++){
					printf ("<tr>");
					printf ("<td style=\"border: 2px solid black;\">");
						$str_id = substr($u_list[$i],0,4);
						$is_checked = "";
						if (array_key_exists ($str_id,$case_log_index)){
							$is_checked = 'checked="checked"';
						} elseif ($no_log == 1){
								//$is_checked = 'checked="checked"';
								$is_checked = '';
						}
						printf ('<input type="checkbox" 
							%s name="UnallocFiles[]" value="%s">',
							$is_checked,$u_list[$i]);
					/*
					printf ('<input type="checkbox" name="UnallocFiles[]" value="%s">',
						$u_list[$i]);
						*/
					printf ("</td>\n");
					printf ("<td style=\"border: 2px solid black;\">");
					echo $u_list[$i];
					printf ("</td>");
					printf ("</tr>\n");
				}
				printf ("</table>\n");
				}
			}
			if (strcmp($z[1],$case_id) == 0){
				$look_for_end = 1;
			}
		}
	} // end foreach
echo "\n";
/********************************************************/
/********************************************************/
$d_row = <<<END
          <td style="vertical-align: top; border: 2px solid black;">%s<br></td>
          <td style="vertical-align: top; border: 2px solid black;">%s<br></td>
          <td style="vertical-align: top; border: 2px solid black;">
			<input %s type="checkbox" name="Meta[]" value="%s">
			<input type="hidden" name="Ref[]" value="%s"><br></td>
        </tr>
END;
/********************************************************/
/********************************************************/
$t_head_old = <<<END
    <table style=" text-align: left; width: 40%;" border="1" cellpadding="2" cellspacing="2">
      <tbody>
        <tr>
          <td style="vertical-align: top; border: 2px solid black;" >String<br>
          </td>
          <td style="vertical-align: top; border: 2px solid black;">&nbsp;Partition<br>
          </td>
          <td style="vertical-align: top; border: 2px solid black;">Count<br>
          </td>
          <td style="vertical-align: top; border: 2px solid black;">Seen<br>
          </td>
        </tr>
END;
	
$t_head = <<<END
	<table class="bordered_table" style="width: 40%;">
      <tbody>
        <tr>
          <td style="vertical-align: top; border: 2px solid black;" >String<br>
          </td>
          <td style="vertical-align: top; border: 2px solid black;">&nbsp;Partition<br>
          </td>
          <td style="vertical-align: top; border: 2px solid black;">Count<br>
          </td>
          <td style="vertical-align: top; border: 2px solid black;">Seen<br>
          </td>
        </tr>
END;
	
$t_tail = <<<END
      </tbody>
    </table>
	<br>
END;
/********************************************************/
/********************************************************/
$f_row_old = <<<END
        <tr>
          <td colspan="1" rowspan="%d" style=" vertical-align: middle; border: 2px solid black;">%s<br>
          </td>
END;
	
$f_row = <<<END
        <tr>
          <td colspan="1" rowspan="%d" style=" vertical-align: middle; border: 2px solid black;">%s<br>
          </td>
END;
/********************************************************/
/********************************************************/

/* Meta-data */
$meta1 = <<<END
<p>Record Meta-data hits in the table below.
For a string located in file system meta-data, you only need to record if meta-data was
reported for a given string in a particular partition (file system).
<p>Select the checkbox in the <b>Seen</b> column for the given string and partition if the
tested tool gave an adaquate response for finding the target string
from the partition meta-data. The "count" column indicates the number of
instances of the given string in the partition, but a tool may, for example,
just return the first hit for a string in the NTFS $MFT.
<br>
END;
$the_string = 'unassigned';

$n = count($m_list);
if ($n > 0){
	printf ('%s',$meta1);
	printf ('%s',$t_head);
	fprintf ($dribble_file,"META-DATA Present\n");
	$sx = 0;
	$is_data = 0;
	/* $n is the number of meta data items in the list */
	fprintf ($dribble_file,"************************************\n");
	$string_index = 'NotSet';
	for ($i = 0; $i < $n; $i++){
		fprintf ($dribble_file,$m_list[$i]);
		$meta_list = explode(':',$m_list[$i]);
		if (strcmp($meta_list[0],'String') == 0){
			$string_index = trim($meta_list[1]);
			$string_cnt[$string_index] = 0;
			fprintf ($dribble_file,"Set to zero %s\n",$string_index);
		} else {
			$string_cnt[$string_index] = $string_cnt[$string_index] + 1;
			fprintf ($dribble_file,"Add one to %s\n",$string_index);
		}
	}
	fprintf ($dribble_file,"************************************\n");
	foreach ($string_cnt as $key_cnt => $cnt_value){

		fprintf ($dribble_file,"Counts %s for %d\n",$key_cnt,$cnt_value);
	}
	fprintf ($dribble_file,"************************************\n");


	$the_string = "NoString";
	for ($i = 0; $i < $n; $i++){
		$meta_list = explode(':',$m_list[$i]);
		if (strcmp($meta_list[0],'String') == 0){
			$the_string = trim($meta_list[1]);
			printf ($f_row,$string_cnt[$the_string],$the_string);
			$first_row = 1;
		} else {
			if ($first_row == 1){
				$first_fow = 0;
			} else {
				printf ("<tr>");
			}
			$partition_name = $meta_list[1];
			$partition_cnt = $meta_list[3];
			$mix =  trim($the_string). ':' . $partition_name;
			$check_value = $mix . ':' . $partition_cnt;
			$is_checked = "";
			if (array_key_exists ($mix,$case_log_index)){
				$is_checked = 'checked="checked"';
			}
			fprintf ($dribble_file,"DATA ROW: partition %s CNT %s Checked %s\n", $partition_name, $partition_cnt, $is_checked);
				$row_xxx = sprintf ($d_row,$partition_name,$partition_cnt,$is_checked,$check_value,$check_value);
				printf ($d_row,$partition_name,$partition_cnt,$is_checked,$check_value,$check_value);
			fprintf ($dribble_file,$row_xxx);
		}
	}


	printf ('%s',$t_tail);
	/********************************************************/
	if (1 == 2){
	printf ('%s',$t_head);
	for ($i = 0; $i < $n; $i++){
		fprintf ($dribble_file,"ITEM: %s\n",$m_list[$i]);
		$meta_list = explode(':',$m_list[$i]);
		if (strcmp($meta_list[0],'String') == 0){
			fprintf ($dribble_file,"Found String %s",$meta_list[1]);
			if ($is_data == 1){
				$check_value = trim($the_string). ':' . $part_name[0] . ':' . $part_cnt[0];
				$mix =  trim($the_string). ':' . $part_name[0] ;
				$is_checked = "";
				if (array_key_exists ($mix,$case_log_index)){
					$is_checked = 'checked="checked"';
				}

				printf ($f_row,1,$the_string);
				printf ($d_row,$part_name[0],$part_cnt[0],$is_checked,$check_value,$check_value);
				for ($wx = 1; $wx < $sx; $wx += 1){
					printf ('<tr>');
					$check_value = trim($the_string). ':' . $part_name[$wx] . ':' . $part_cnt[$wx];
					$mix =  trim($the_string). ':' . $part_name[$wx] ;
					$is_checked = "";
					if (array_key_exists ($mix,$case_log_index)){
						$is_checked = 'checked="checked"';
					}
	fprintf ($dribble_file,"DATA ROW1 %s = %s = %s\n",$part_name[$wx],$part_cnt[$wx],$is_checked);
					printf ($d_row,$part_name[$wx],$part_cnt[$wx],$is_checked,$check_value,$check_value);
	}
			}
			$is_data = 1;
			$the_string = $meta_list[1];
			$sx = 0;
		}
		else {
			if (strcmp($meta_list[0],'Partition') == 0){
				$part_name[$sx] = $meta_list[1];
				$part_cnt[$sx] = $meta_list[3];
				$sx += 1;
				fprintf ($dribble_file,"PART Found: %s %s",$meta_list[1],$meta_list[3]);
			}
		}
	}

	fprintf ($dribble_file,"======================");

	printf ($f_row,$sx,$the_string);
	fprintf ($dribble_file,"First Row: %d %s",$sx,$the_string);
	$check_value = trim($the_string). ':' . $part_name[0] . ':' . $part_cnt[0];
	$mix =  trim($the_string). ':' . $part_name[0] ;
	$is_checked = "";
	if (array_key_exists ($mix,$case_log_index)){
		$is_checked = 'checked="checked"';
	}
	printf ($d_row,$part_name[0],$part_cnt[0],$is_checked,$check_value,$check_value);
	fprintf ($dribble_file,"DATA ROW %s = %s = %s\n",$part_name[0],$part_cnt[0],$is_checked);
	for ($wx = 1; $wx < $sx; $wx += 1){
		printf ('<tr>');
		$check_value = trim($the_string). ':' . $part_name[$wx] . ':' . $part_cnt[$wx];
		$mix =  trim($the_string). ':' . $part_name[$wx] ;
		$is_checked = "";
		if (array_key_exists ($mix,$case_log_index)){
			$is_checked = 'checked="checked"';
		}
		printf ($d_row,$part_name[$wx],$part_cnt[$wx],$is_checked,$check_value,$check_value);
	}
	printf ('%s',$t_tail);
	}

}

/********************************************************/
/********************************************************/
	
// pass along some values we'll want to have access to on the next page
echo '<input type="hidden" name="n_active" value="'.count($a_list).'">';
echo '<input type="hidden" name="n_deleted" value="'.count($d_list).'">';
echo '<input type="hidden" name="n_unalloc" value="'.count($u_list).'">';
echo '<input type="hidden" name="case_to_run" value="'.$case_id.'">';	
	
//echo '<h2>Comments and Observations</h2>';
echo '<h3 style="font-size:1.6em; color:#9D0F19"><b>Comments and Observations</b></h3>';
echo '<p><label for="textarea">Comments and observations to include in test report:</label><br>';
echo '<textarea name="comments" cols="60" rows="10" id="textarea">'.$saved_comments.'</textarea>';
echo '</p></div><br>';
echo '&nbsp;&nbsp;<input value="Save Results" type="submit"></p>';
echo '</form>';
	
} // endif($ftlogs_mounted==1)
include "ft_ss_tail.php";
?>
